/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.sys;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.PIHscLockPolicy;
import com.ibm.hsc.fsp.AsyncEventListener;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.FspConnErrorHandler;
import com.ibm.hsc.fsp.ParamConvertor;
import com.ibm.hsc.fsp.cmdhelpers.FspAuthInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspQueryData;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.frame.OmFrameMgr;
import com.ibm.hsc.objmgr.sys.OmSysAsyncEvtHandler;
import com.ibm.hsc.objmgr.sys.OmSysConnUpdater;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50Frame;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public abstract class OmSysMgr
implements FspConnErrorHandler,
ParamConvertor {
    protected RObjectId mSysOid = null;
    protected RObject mSysObj = null;
    protected FspCmdHelper mCmdHelper = null;
    protected FSPCmdMgr mCmdMgr = null;
    protected String mSysName;
    protected OmSysAsyncEvtHandler mAsyncHandler = null;
    protected OmSysConnUpdater mConnUpdater = null;
    protected HSCEventIndicationMgr mIndMgr = null;
    protected FspLockHelper mCodeUpdateLock = null;
    protected static Hashtable sSysMgrHash = new Hashtable();
    public static final int LINE_UP = 0;
    public static final int WAITING_FOR_CMD_SERVER_CONNECT = 1;
    public static final int CEC_VERSION_PENDING = 4;
    public static final int CEC_AUTHENTICATION_PENDING = 8;
    public static final int CEC_PASSWORD_CHANGE_PENDING = 11;
    public static final int CEC_IMPL_LIMIT_PENDING = 16;
    public static final int LINE_DOWN = 32768;
    public static final int LINE_DOWN_BAD_NAME = 32769;
    public static final int LINE_CONNECTING = 32770;
    public static final int LINE_DOWN_CONNECT_REFUSED = 32771;
    public static final int LINE_DOWN_IO_FAIL = 32772;
    public static final int CEC_AUTHENTICATION_FAILED = 32773;
    public static final int LINE_DOWN_POLL_TIMEOUT = 32774;
    public static final int CEC_INCOMPATIBLE = 32775;
    public static final int TEMPRARY_DISCONNECT = 65535;
    public static final int PERMANENTLY_DISCONNECTED_STATE = 65534;
    public static final int RESET_CONNECTION_STATE = 65532;
    public static final int CAP_MISMATCH_CHANGED = 1;
    public static final int CAP_MISMATCH_NO_CHANGE = 2;
    public static final int CAP_NORMAL_CHANGED = 3;
    public static final int CAP_NORMAL_NO_CHANGE = 4;
    public static final int CAP_INCOMPLETE_CHANGED = 5;
    public static final int CAP_INCOMPLETE_NO_CHANGE = 6;
    private static final int INCORRECT_PASSWORD_RC = 38;

    public OmSysMgr(FspQueryData fspQueryData, byte[] byArray) throws RException, PIHscCmdMgrException {
        this.mSysName = fspQueryData.getMtms();
    }

    protected void initialize(FspQueryData fspQueryData, byte[] byArray) {
        this.mCmdMgr = new FSPCmdMgr(this);
        this.mIndMgr = HSCEventIndicationMgr.getInstance();
        this.mCmdHelper = new FspCmdHelper(this.mCmdMgr);
        this.mConnUpdater = new OmSysConnUpdater(this);
        this.createAsyncHandler();
        try {
            this.createRObject(fspQueryData, byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("created sys mgr");
    }

    public static OmSysMgr createSysMgr(FspQueryData fspQueryData, byte[] byArray) {
        OmSysMgr omSysMgr = null;
        String string = fspQueryData.getMtms();
        Object var4_4 = null;
        try {
            OmSysMgr omSysMgr2;
            int n = fspQueryData.getCmdServerConnState().intValue();
            if (n == 16) {
                System.out.println("skip CEC_IMPL_LIMIT_PENDING connState, return");
                return null;
            }
            String string2 = OmSysMgr.buildDummyMtms(fspQueryData, byArray);
            if (!string2.equals(string) && (omSysMgr2 = (OmSysMgr)sSysMgrHash.get(string2)) != null) {
                System.out.println("delete dummy sysMgr");
                omSysMgr2.deleteSysAll();
            }
            boolean bl = OmSysMgr.createNewSysMgrInst(fspQueryData, byArray);
            omSysMgr = (OmSysMgr)sSysMgrHash.get(string);
            if (omSysMgr == null) {
                return null;
            }
            if (bl) {
                HSCLogUtils.logSystemEvent((short)2001, "Sys Conn", new String[]{"adding " + fspQueryData.getMtms()}, "object " + omSysMgr.getClass().getName());
            }
            omSysMgr.updateQueryData(fspQueryData, byArray, bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return omSysMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean createNewSysMgrInst(FspQueryData fspQueryData, byte[] byArray) throws RException, PIHscCmdMgrException, PIHscServerException {
        OmSysMgr omSysMgr = (OmSysMgr)sSysMgrHash.get(fspQueryData.getMtms());
        if (omSysMgr != null) {
            return false;
        }
        PIHscLockPolicy pIHscLockPolicy = PIHscLockPolicy.getPIHscLockPolicy("IBMHSC_ComputerSystem");
        Lock lock = Lock.getInstance("root/ibmhscS1_0", fspQueryData.getMtms());
        try {
            lock.lock(pIHscLockPolicy.getLockType("RebuildCec"));
            int n = fspQueryData.getCmdServerConnState().intValue();
            if (n == 32768 || n == 65534) {
                System.out.println("conn state is " + n + ", SysMgr doesn't exist. return");
                boolean bl = false;
                return bl;
            }
            System.out.println("conn state is " + n);
            System.out.println("sys is new ...");
            omSysMgr = fspQueryData.isFrame() ? new OmFrameMgr(fspQueryData, byArray) : new OmCecMgr(fspQueryData, byArray);
            sSysMgrHash.put(fspQueryData.getMtms(), omSysMgr);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateQueryData(FspQueryData fspQueryData, byte[] byArray, boolean bl) throws PIHscServerException, RException, PIHscServerException {
        int n = -1;
        int n2 = -1;
        boolean bl2 = false;
        if (!bl) {
            n = this.mCmdMgr.getConnState();
            n2 = this.mCmdMgr.getVport();
        }
        System.out.println("old conn state: " + n);
        int n3 = fspQueryData.getCmdServerConnState().intValue();
        System.out.println("connState: " + n3);
        this.mCmdMgr.updateQueryData(fspQueryData, byArray);
        PIHscLockPolicy pIHscLockPolicy = PIHscLockPolicy.getPIHscLockPolicy("IBMHSC_ComputerSystem");
        Lock lock = Lock.getInstance("root/ibmhscS1_0", fspQueryData.getMtms());
        try {
            lock.lock(pIHscLockPolicy.getLockType("RebuildCec"));
            if (n3 == 65534 || n3 == 65532) {
                if (n3 == 65534) {
                    this.deleteConn(fspQueryData);
                }
                if (this.mCmdMgr.isClosed()) {
                    System.out.println("last conn deleted, delete rep data");
                    this.deleteSysAll();
                    return;
                }
            }
            short s = this.mCmdMgr.getSysState();
            System.out.println("sysState: " + s);
            RObject rObject = (RObject)this.getObject().clone();
            int n4 = HardwareServerMessage.bytesToUInt(byArray, 0);
            if (this.repUpdateConnData(n2, n4, s, fspQueryData, bl)) {
                bl2 = true;
            }
            if (n2 == this.mCmdMgr.getVport() && !bl2 && !bl) {
                System.out.println("new conn state:" + this.mCmdMgr.getConnState());
                if (n == this.mCmdMgr.getConnState() || s == 14) {
                    if (bl2) {
                        this.sendModifiedIndication(rObject);
                    }
                    System.out.println("no conn state change return");
                    return;
                }
            }
            if (this.repUpdateStateData(s)) {
                bl2 = true;
            }
            if (s == 4 && this.reinitialize()) {
                bl2 = true;
            }
            if (bl) {
                System.out.println("send out create indication");
                HSCEventIndicationMgr.getInstance().sendIndication(1, this.getObject(), null);
                this.sentCreationEvent();
            } else if (bl2) {
                System.out.println("send out update indication");
                this.sendModifiedIndication(rObject);
            }
            if (s == 4) {
                System.out.println("before rebuild");
                this.updateSysAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean repUpdateConnData(int n, int n2, int n3, FspQueryData fspQueryData, boolean bl) throws RException {
        System.out.println("update conndata for " + n2);
        try {
            this.mConnUpdater.update();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    protected abstract boolean reinitialize();

    protected abstract void sentCreationEvent();

    protected abstract boolean repUpdateStateData(int var1) throws RException;

    protected abstract void createAsyncHandler();

    protected abstract void createRObject(FspQueryData var1, byte[] var2) throws RException;

    public abstract void updateSysAll() throws PIHscServerException;

    public abstract void sysDisconnected(long var1);

    protected abstract void unlockSysAll() throws PIHscServerException;

    protected abstract int getSysType();

    public void deleteSysAll() throws PIHscServerException, RException {
        HSCLogUtils.logSystemEvent((short)2001, "Sys Conn", new String[]{"deleting " + this.mSysName}, "object " + this.getClass().getName());
        int n = R50Define.AID_IBMHSC_FrameConnection;
        if (this instanceof OmCecMgr) {
            n = R50Define.AID_IBMHSC_CompSysConnection;
        }
        System.out.println("remove conn objects");
        this.mSysObj.deleteAssociated(n);
        System.out.println("removing sys inst");
        this.mSysObj.deleteInstance();
        System.out.println("removing from sysmgr hash");
        sSysMgrHash.remove(this.mSysName);
        System.out.println("sending delete indication");
        this.getIndMgr().sendIndication(2, this.mSysObj, null);
    }

    protected int updIntfCapNoException() {
        try {
            return this.updateInterfaceCapability();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                System.out.println("set to INCOMPLETE");
                int n = R50ComputerSystem.Index_State;
                if (this instanceof OmFrameMgr) {
                    n = R50Frame.Index_State;
                }
                if (this.mSysObj.setProperty(n, (Object)new UnsignedInt8(253))) {
                    return 5;
                }
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            return 6;
        }
    }

    public int updateInterfaceCapability() throws RException, PIHscServerException {
        int n = R50ComputerSystem.Index_State;
        if (this instanceof OmFrameMgr) {
            n = R50Frame.Index_State;
        }
        try {
            UnsignedInt8[] unsignedInt8Array = this.mCmdHelper.getInterfaceCapabilities();
            int n2 = R50ComputerSystem.Index_Capability;
            if (this instanceof OmFrameMgr) {
                n2 = R50Frame.Index_Capability;
            }
            if (this.mSysObj.setProperty(n2, (Object)unsignedInt8Array)) {
                System.out.println("rtn = CAP_NORMAL_CHANGED");
                return 3;
            }
            System.out.println("rtn = CAP_NORMAL_NO_CHANGE");
            return 4;
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
            if (pIHscCmdMgrException.getStatus() == 50) {
                System.out.println("version mismatch");
                if (this.mSysObj.setProperty(n, (Object)new UnsignedInt8(250))) {
                    return 1;
                }
                return 2;
            }
            System.out.println("Throw cmd exception");
            throw pIHscCmdMgrException;
        }
    }

    protected void deleteConn(FspQueryData fspQueryData) {
    }

    public static String buildDummyMtms(FspQueryData fspQueryData, byte[] byArray) {
        int n = HardwareServerMessage.bytesToUInt(byArray, 0);
        return "0-0*" + n;
    }

    public int getConnState() {
        return this.mCmdMgr.getConnState();
    }

    public HSCEventIndicationMgr getIndMgr() {
        return this.mIndMgr;
    }

    public static OmSysMgr getSysMgr(String string) {
        return (OmSysMgr)sSysMgrHash.get(string);
    }

    public static OmSysMgr getSysMgrByIP(String string) {
        Object object;
        OmSysMgr omSysMgr = null;
        String string2 = null;
        String string3 = null;
        try {
            object = InetAddress.getByName(string);
            string2 = ((InetAddress)object).getHostName();
            string3 = ((InetAddress)object).getHostAddress();
            System.out.println("JPD:  lookup:  targetHostname = " + string2);
            System.out.println("JPD:  lookup:  targetIpAddr   = " + string3);
        }
        catch (Throwable throwable) {
            string3 = string2 = string;
        }
        if (string2.equals("127.0.0.1")) {
            string2 = string;
            string3 = string;
        }
        object = sSysMgrHash.elements();
        while (object.hasMoreElements()) {
            OmSysMgr omSysMgr2 = (OmSysMgr)object.nextElement();
            try {
                if (!omSysMgr2.isConnIp(string3) && !omSysMgr2.isConnIp(string2)) continue;
                omSysMgr = omSysMgr2;
                System.out.println("JPD:  FOUND IT!!!");
                break;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return omSysMgr;
    }

    protected boolean isConnIp(String string) {
        return this.mCmdMgr.isConnIp(string);
    }

    public RObjectId getObjectId() {
        return this.mSysOid;
    }

    public RObject getObject() {
        return this.mSysObj;
    }

    public static Vector getAllSysIpAddr() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = sSysMgrHash.elements();
        while (enumeration.hasMoreElements()) {
            OmSysMgr omSysMgr = (OmSysMgr)enumeration.nextElement();
            Vector vector2 = omSysMgr.getCmdMgr().getAllIpAddrs();
            if (vector2 == null || vector2.size() < 1) continue;
            for (int i = 0; i < vector2.size(); ++i) {
                String string = (String)vector2.elementAt(i);
                if (string == null) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    public String getSysName() {
        return this.mSysName;
    }

    public Object getProperty(String string) throws RException {
        return this.mSysObj.getProperty(string);
    }

    public boolean setProperty(String string, Object object) throws RException {
        return this.mSysObj.setProperty(string, object);
    }

    public boolean setProperty(int n, Object object) throws RException {
        return this.mSysObj.setProperty(n, object);
    }

    public FspCmdHelper getCmdHelper() {
        return this.mCmdHelper;
    }

    public FSPCmdMgr getCmdMgr() {
        return this.mCmdMgr;
    }

    public void sendModifiedIndication(RObject rObject) {
        HSCEventIndicationMgr.getInstance().sendIndication(4, this.getObject(), rObject);
    }

    public boolean isFspAvailable() {
        short s = this.mCmdMgr.getSysState();
        if (s == 4) {
            return true;
        }
        return s == 14 && this.mCmdMgr.getConnState() == 16;
    }

    public void hwSrvDisconnected(long l) {
        if (this.mSysName.startsWith("0-0*")) {
            try {
                this.deleteSysAll();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            this.sysDisconnected(l);
        }
        this.mCmdMgr.close(false);
    }

    public boolean deleteSysAll(byte by, String string) {
        return this.mCmdHelper.removeSys(by, string);
    }

    public String getCmdServerFailedExtReasonStr(FspQueryData fspQueryData) {
        long l = fspQueryData.getCmdServerFailedExtReason().longValue();
        if ((l == 1029L || l == 8L) && this.mSysName != null) {
            return fspQueryData.getHexString(l, 4) + "-(" + this.mSysName + ")";
        }
        return fspQueryData.getCmdServerFailedExtReasonStr();
    }

    public AsyncEventListener getAsyncListener() {
        return this.mAsyncHandler.getAsyncListener();
    }

    public String drcIndexToLocationCode(UnsignedInt32 unsignedInt32) {
        return null;
    }

    public int platformPassword(String string) throws PIHscServerException {
        FspAuthInfo fspAuthInfo = this.mCmdHelper.authPlatformPassword(string);
        return fspAuthInfo.getRetCode().intValue();
    }

    public int setPassword(UnsignedInt8 unsignedInt8, String string, String string2) throws PIHscServerException {
        System.out.println("Calling setPasswords");
        FspAuthInfo fspAuthInfo = this.mCmdHelper.authSetPasswords(this.mSysName, unsignedInt8, string, string2);
        System.out.println("returnCode = " + fspAuthInfo.getRetCode());
        System.out.println("passwordStatusFlags = " + fspAuthInfo.getPasswordStatusFlags());
        int n = fspAuthInfo.getRetCode().intValue();
        if (n == 38 && string.equals("")) {
            System.out.println("try again with new passwod as cur password");
            fspAuthInfo = this.mCmdHelper.authSetPasswords(this.mSysName, unsignedInt8, string2, string2);
            System.out.println("returnCode = " + fspAuthInfo.getRetCode());
            System.out.println("passwordStatusFlags = " + fspAuthInfo.getPasswordStatusFlags());
        }
        return fspAuthInfo.getRetCode().intValue();
    }
}

